#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Clover fieldMod01.fsh    by    jolle  
//https://www.shadertoy.com/view/3c2XRd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define t iTime

vec4 clover(vec2 uv)
{
    // Leaf shape as distance field
    float ad = abs(abs(uv.x) - abs(uv.y));
    float d = .4 + sqrt(abs(uv.x * uv.y)) * .85 + .2 * ad;
    float l = length(uv);
    float ld = l - d;

    // Leaf shading
    vec4 c = vec4(0);
    c.g = max(0., .5 * d * d + .25 - max(.1 - ad * .25, 0.));

    // Highlight ring
    float a = atan(uv.x, uv.y);
    l += sin(a * 20.) * .02 + sin(a * 10.) * .025 - d * .4 + .25;
    c += vec4(.14) * (smoothstep(.31, .36, l) - smoothstep(.43, .48, l));

    // Outline/shadow + AA
    c.rgb *= clamp(1. - ld * 75., 0., 1.);
    c.a = clamp(1. - ld * 20., 0., 1.);

    return c;
}

vec4 field(vec2 uv)
{
    vec4 c0 = vec4(0);
    for (int y = 0; y < 3; ++y)
        for (int x = 0; x < 3; ++x)
        {
            vec2 h = floor(uv) + vec2(x, y);
            vec2 o = vec2(sin(t + h.x * 123. + h.y) * .25, sin(t * .7 + h.x * 234. + h.y * .43) * .25);
            vec2 p = (uv - h - o) * 2.;
            vec2 r = cos(t * .1 + h.x * 2. + cos(h.y) + vec2(0., 3.14 * .5));
            float s = .75 + cos(t * 3. + cos(h.y * 2.) + cos(h.x * 35.)) * .125;
            vec4 c = clover(mat2x2(r.x, -r.y, r.y, r.x) * p * s);
            c0 = mix(c0, c, c.a);
        }
    return c0;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord ){
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.y * 7.5;
    vec4 f0 = field(uv * 2.) * .4;
    vec4 f1 = field(uv + .5) * vec4(vec3(.7), 1.);
    vec4 f2 = field(uv);
    fragColor = mix(mix(f0, f1, f1.a), f2, f2.a);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

